/******************************************************************************

    URBAN
    Copyright (C) 1999  Thomas Nyberg and Jonas Borgstrm

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact the authors:
    Snailmail:
    Thomas Nyberg					Jonas Borgstrm
    Brnnbergsvgen 21b					Bondevgen 6
    92136 Lycksele					92332 Storuman
    Sweden						Sweden

    or email:

    thomas.nyberg@usa.net				jonas_b@bitsmart.com
*****************************************************************************/
#include <allegro.h>
#include "object.h"
#include "engine.h"

#define FRAME_DELAY 	4
#define BURN_DELAY	2000

Fire_o::Fire_o(int X, int Y, int Z, int size)
	: Object(X, Y, Z) {

	RGB pal[256];
        char filename[512];
        int i;

        anim.reset();
        images = new BITMAP*[4];


        for (i =0;i < 4;i++) {
		sprintf(filename, "%s/%d.pcx", size == 1 ? "fire" : "smallfir", i + 1);
                images[i] = icache.GetImage(filename, pal);
                if (images[i])
                	num_images++;
	}

        height = images[0]->h;
        width = images[0]->w;
        coll_x = 0;
        coll_y = 0;
        coll_width = width;
        coll_height = height;

        current_image = 0;
        //st med ftterna
        y -= (height / 2);

        energy = 1;
        strength = 2;
        speed_x = 0;
        speed_y = 0;
        speed_z = 0;
        score = 0;
        friends = ~0;
	enemies = 0;
        counter = BURN_DELAY;
}

Fire_o::~Fire_o() {
}

int Fire_o::update() {
	if (counter)
        	counter--;
	else
        	return -1;
	current_image = anim.next_frame(3, FRAME_DELAY);
	return 0;
}

